package jamezo97.clonecraft.render;

import jamezo97.clonecraft.dna.IModifiable;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.CCEntityClientPlayerMP;
import net.minecraft.client.entity.CCEntityOtherPlayerMP;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;

import org.lwjgl.opengl.GL11;

public class RenderClientPlayer extends RenderPlayer{

	@Override
	protected void renderPlayerScale(AbstractClientPlayer p, float par2) {
		float scale = getScale(p);
		GL11.glScalef(scale, scale, scale);
	}

	public float getScale(Entity e){
		if(e instanceof IModifiable){
			return ((IModifiable)e).getGeneScaling() * 0.9375F;
		}
		return 0.9375F;
	}

	@Override
	public void doRender(Entity par1Entity, double par2, double par4,
			double par6, float par8, float par9) {

		if(par1Entity.ticksExisted > 0){
			GL11.glPushMatrix();
			float scale = ((IModifiable)par1Entity).getGeneScaling();
			if(par1Entity instanceof CCEntityClientPlayerMP){
				GL11.glTranslatef(0.0f, par1Entity.yOffset-1.62f, 0.0f);
			}else if(par1Entity instanceof CCEntityOtherPlayerMP){
				GL11.glTranslatef(0.0f, par1Entity.yOffset-1.62f, 0.0f);
			}


			super.doRender(par1Entity, par2, par4, par6, par8, par9);
			GL11.glPopMatrix();
		}

	}





}
